<?php

namespace App\Http\Controllers\client;

use App\Models\Order;
use App\Models\Accounts;
use App\Models\RiskFund;
use App\Models\FootPrint;
use App\Models\SpendMoney;
use App\Models\AssignTable;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\BudgetReceived;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ClientAccountsController extends Controller
{
    public function index()
    {
        $id = Auth::user()->id;
        $datas = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->orderBy('id','desc')->get();
        $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');

        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

        return view('admin.page.accounts.client.partialPayment.orderList', get_defined_vars());
    }

    public function completeOrders()
    {
        $id = Auth::user()->id;
        $datas = Order::where('order_creator_id', $id)->where('total_due', '>', 0)->whereIn('status',[1,2,3])->where('order_status',10)->orderBy('id','desc')->get();
        $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');

        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

        return view('admin.page.accounts.client.partialPayment.orderList', get_defined_vars());
    }

    public function cancleOrders()
    {
        $id = Auth::user()->id;
        $datas = Order::where('order_creator_id', $id)->where('total_due', '>', 0)->whereIn('status',[1,2,3])->where('order_status',11)->orderBy('id','desc')->get();
        $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');

        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

        return view('admin.page.accounts.client.partialPayment.cancelOrderList', get_defined_vars());
    }


    public function findClientsCurrentBalance(Request $request)
    {
        $findOrder = Order::where('id', $request->orderID)->first();

        $totalPay = Order::where('order_creator_id', $findOrder->order_creator_id)->whereIn('status',[1,2,3])->sum('total_pay');
        $totalReceived = BudgetReceived::where('client_id', $findOrder->order_creator_id)->whereIn('status', [1,2])->sum('received_amount');
        $currentBalance = $totalReceived - $totalPay;
        echo json_encode($currentBalance);
    }

    public function findCompleteWorksWhenHold(Request $request)
    {
        $findCompleteWorks = AssignTable::where('order_id', $request->orderID)->first();
        $CompleteWorks = $findCompleteWorks->complete_work;
        echo json_encode($CompleteWorks);
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'payment_method_id' => 'required',
            'payment_amount' => 'required',
            'trans_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new SpendMoney();
            $data->order_id = $request->order_id;
            $data->client_id = $request->client_id;
            $data->transactionID = $request->transactionID;
            $data->payment_method_id= $request->payment_method_id;

            $data->payment_amount = $request->payment_amount;
            $data->due = $request->due;
            $data->charge = $request->charge;
            $data->total_received_amount = $request->total_received_amount;
            $data->charge_note = $request->charge_note;

            $data->trans_date= $request->trans_date;
            $data->note= $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 3;
            $data->save();
            // dd($data);

            $notification= array(
                'message' =>'Order Payment Received Successfully',
                'alert-type'=>'success'
            );

            return back()->with($notification);
        }
    }

    public function clientOrderPayAccept($id)
    {
        // dd($id);
        $data = SpendMoney::find($id);
        $data ->status         = 2;
        $data ->updated_by     = Auth::user()->id;
        $data ->updated_date   = Carbon::now();
        $data->save();

        $saveTrans = new Transaction();
        $saveTrans->trans_type = 12;
        $saveTrans->amount = $data->payment_amount;
        $saveTrans->date= $data->trans_date;
        $saveTrans->spend_money_id = $data->id;
        $saveTrans->note = $data->note;
        $saveTrans->created_by = Auth::user()->id;
        $saveTrans->created_date = Carbon::now();
        $saveTrans->status = 1;
        $saveTrans->save();
        // dd($saveTrans);

        $findOrder = Order::where('id', $data->order_id)->first();
        $totalPay = $findOrder->total_pay + $data->payment_amount;
        $totalDue = $findOrder->total_due - $data->payment_amount;
        Order::find($data->order_id)->update([
            'total_pay'=> $totalPay,
            'total_due'=> $totalDue,
        ]);

        $accountsTotal = Accounts::first();
        $findOrderDetails = Order::where('id', $data->order_id)->first();

        $totalReceivedAmount = SpendMoney::where('order_id', $data->order_id)
                            ->where('client_id', $data->client_id)
                            ->sum('total_received_amount');

        if($findOrderDetails->order_status == 10 && $findOrderDetails->total_budget == $findOrderDetails->total_pay){

            // dd('Risk Fund');
            $getTotalCost = AssignTable::where('order_id', $data->order_id)->sum('total_service_cost');

            $profit = $totalReceivedAmount - $getTotalCost;

            Order::find($data->order_id)->update([
                'profit'=> $profit,
            ]);

            $findRiskFund = RiskFund::first();
            $percentage = ($profit * 5) / 100 ;
            $totalRiskFund = $findRiskFund->total + $percentage;

            if($totalRiskFund < 300 ){

                $Credit = $findRiskFund->credit + $percentage;
                $totalFund = $findRiskFund->total + $percentage;

                if($Credit > 0 && $totalFund > 0){
                    RiskFund::find(1)->update([
                        'credit'=> $Credit,
                        'total'=> $totalFund,
                    ]);
                }
                $totalCredit = ($accountsTotal->credit + $data->total_received_amount) - $percentage;
                $totalAmount = ($accountsTotal->total + $data->total_received_amount) - $percentage;
                // dd($totalCredit);
                Accounts::find(1)->update([
                    'credit'=> $totalCredit,
                    'total'=> $totalAmount,
                ]);

            }else{

                $riskAmount = $totalRiskFund - 300 ;
                $Credit = $findRiskFund->credit + $percentage - $riskAmount;
                $totalFund = $findRiskFund->total + $percentage - $riskAmount;

                if($Credit > 0 && $totalFund > 0){
                    RiskFund::find(1)->update([
                        'credit'=> $Credit,
                        'total'=> $totalFund,
                    ]);
                }

                $totalCredit = ($accountsTotal->credit + $data->total_received_amount) - ($percentage - $riskAmount);
                $totalAmount = ($accountsTotal->total + $data->total_received_amount) - ($percentage - $riskAmount);
                // dd($totalCredit);
                Accounts::find(1)->update([
                    'credit'=> $totalCredit,
                    'total'=> $totalAmount,
                ]);
            }

        }else{
            $totalCredit = $accountsTotal->credit + $data->total_received_amount;
            $totalAmount = $accountsTotal->total + $data->total_received_amount;

            // dd($totalCredit);

            Accounts::find(1)->update([
                'credit'=> $totalCredit,
                'total'=> $totalAmount,
            ]);
        }

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "OrderPaymentReceived";
        $fData->table_id = $data->id;
        $fData->comment = "Order Payment Received";
        $fData->status = 1;
        $fData->save();

        $notification= array(
            'message' =>'Order Payment Received Successfully',
            'alert-type'=>'success'
        );

        return back()->with($notification);
    }
    public function clientOrderPayDeclined($id)
    {

        $data = SpendMoney::find($id);
        $data ->status         = 4;
        $data ->updated_by     = Auth::user()->id;
        $data ->updated_date   = Carbon::now();
        $data->save();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "VendorBudgetReceived";
        $fData->table_id = $data->id;
        $fData->comment = "Budget Received Declined";
        $fData->status = 4;
        $fData->save();
        $notification= array(
            'message' =>'Budget Received Decline Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
        }

    }
