<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{
    public function orderReport()
    {
        return view('admin.page.advanceAnalytics.orderReport', [
            'clients' => User::getClients(),
            'orders' => [],
            'types' => '',
            'selectClients' => '',
            'date_range' => '',
            'total' => '',
        ]);
    }

    public function searchOrderReport(Request $request)
    {
        $dates = explode(' - ', $request->input('dates'));
        $startDate = Carbon::createFromFormat('m/d/Y', trim($dates[0]))->startOfDay();
        $endDate = Carbon::createFromFormat('m/d/Y', trim($dates[1]))->endOfDay();

        $types = $request->input('type');
        $clients = $request->input('clients');

        $query = Order::query();

        // Filter by date range
        $query->whereBetween('created_at', [$startDate, $endDate]);

        // Filter by types
        if (!in_array('all', $types)) {
            $query->whereIn('type', $types);
        }

        // Filter by client IDs
        if (!in_array('all', $clients)) {
            $query->whereIn('client_id', $clients);
        }

        $orders = $query->get();

        $date_range = $startDate->format('m/d/Y') .' - '. $endDate->format('m/d/Y');

        $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
        
        // dd($types, $clients, $date_range, $request->input('dates'));
        
        return view('admin.page.advanceAnalytics.orderReport', [
            'clients' => User::getClients(),
            'orders' => $orders,
            'types' => $types,
            'selectClients' => $clients,
            'date_range' => $date_range,
            'total' => $total,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}