<?php

namespace App\Http\Controllers\admin;

use App\Models\User;
use App\Models\FootPrint;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ManageClientController extends Controller
{
    
    public function active()
    {
        $clients = User::where('role', 3)->whereIn('status',[1,2,3])->get();
        //dd($clients);
        return view('admin.page.clients.activeClient',get_defined_vars());
    }

    public function inactive()
    {
        $clients = User::where('role', 3)->where('status',4)->get();
        //dd($clients);
        return view('admin.page.clients.inactiveClient',get_defined_vars());
    }

    public function all()
    {
        $clients = User::where('role', 3)->where('status','!=',0)->get();
        //dd($clients);
        return view('admin.page.clients.allClient',get_defined_vars());
    }

    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
        ]);
       
         //dd($request->all());
            $user = new User();
            $user->name = $request->name;
            $user->phone = $request->phone;
            $user->email = $request->email;
            $user->gender = $request->gender;
            $user->role = 3;
            $user->password = bcrypt($request->password);
            $user->pass_code = $request->password;
            $user->address = $request->address;
            if($request->dob !=null){
                $user->dob = date('Y-m-d',strtotime($request->dob));
                }
            if ($request->file('image')) {
                $file = $request->file('image');
                $filename = date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/userImage'),$filename);
                $user['image'] = $filename;
            }
            $user->status = 1;
            $user->created_by = Auth::user()->id;
            $user->created_date = Carbon::now();
            $user->save();

            if($user->id !=null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->user_id = $user->id;
            $fData->comment = "Client Inserted";
            $fData->status = 1;
            $fData->save();


            $notification= array(
                'message' =>'Client Inserted Successfully ',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'Client Not Inserted !!!',
                'alert-type'=>'error'
            );

        }
            return redirect()->route('view-active-clients')->with($notification);
    }

    public function editClient($id)
    {
        $data = User::find($id);
        return view('admin.page.clients.editClient',get_defined_vars());
    }

    public function updateClient(Request $request, $id)
    {
         //dd($request->all());
         $this->validate($request,[
            'name' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'gender' => 'required',

        ]);

        $data=User::find($id);

        $data->name=$request->name;
        $data->gender=$request->gender;
        $data->phone=$request->phone;
        $data->gender=$request->gender;
        $data->address=$request->address;
        if($request->dob !=null){
            $data->dob = date('Y-m-d',strtotime($request->dob));
        }
        $data->status = 2;
        if($request->file('image')){
            $file=$request->file('image');

                @unlink(public_path('upload/userImage/'.$data->image));
                $filename=date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/userImage'),$filename);
                $data['image']=$filename;
        }
        $data->save();


        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Client Profile Updated";
        $fData->status = 2;
        $fData->save();

        $notification= array(
            'message' =>'Client Profile Updated successfully',
            'alert-type'=>'success'
        );
        return Redirect()->route('view-active-clients')->with($notification);
    }

    public function InactiveClient($id)
    {
        //dd($id);

        User::where('id',$id)->update([
            'status'=>4,
        ]);
        
        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Inactive Client";
        $fData->status = 4;
        $fData->save();
        $notification= array(
            'message' =>'InActive Client Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }

    public function ActiveClient($id)
    {
        //dd($id);
        User::where('id',$id)->update([
            'status'=>3,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Active Client";
        $fData->status = 3;
        $fData->save();

        $notification= array(
            'message' =>'Active Client Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }

    public function DistroyClient($id)
    {
        //dd($id);
        User::where('id',$id)->update([
            'status'=>0,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Delete User";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Client Deleted Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }

    public function resetPassword($id)
    {
        $data = User::find($id);
        return view('admin.page.clients.editClient',get_defined_vars());
    }
    
}
