<?php

namespace App\Http\Controllers\admin;

use Exception;
use App\Models\User;
use App\Models\Order;
use App\Mail\OrderMail;
use App\Models\FootPrint;
use App\Models\WorkCheck;
use App\Models\AssignTable;
use App\Models\ServiceType;
use App\Models\WorksDetails;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class AdminOrderController extends Controller
{
    public function index()
    {
        $datas = Order::whereIn('status', [1, 2, 3])->orderBy('id', 'desc')->where('order_status', 1)->get();

        if ($datas != null) {
            return view('admin.page.manageOrder.viewPandingOrder', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function declineOrder()
    {
        $datas = Order::whereIn('status', [1, 2, 3])->orderBy('id', 'desc')->where('order_status', 8)->get();

        if ($datas != null) {
            return view('admin.page.manageOrder.viewDeclineOrder', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function newOrder()
    {
        $service = ServiceType::whereIn('status', [1, 2, 3])->get();
        $clients = User::whereIn('status', [1, 2, 3])->where('role', 3)->get();

        return view('admin.page.manageOrder.newOrder', get_defined_vars());
    }
    public function storeNewOrder(Request $request)
    {
        $this->validate($request, [
            'apps_link' => 'required',
            'service_type_id' => 'required',
            'service_cost' => 'required',
            'target_date' => 'required',
        ]);

        $find_id = Order::orderBy('id', 'desc')->first();

        if ($find_id != null) {
            $find_value = $find_id->id;
            $uniqueId = 10000 + $find_value;
        } else {
            $uniqueId = 10000;
        }

        $data = new Order();
        $data->order_unique_id = $uniqueId;
        $data->apps_link = $request->apps_link;
        $data->platform = $request->platform;
        $data->service_type_id = $request->service_type_id;
        $data->total_quantity = $request->total_quantity;
        $data->service_cost = $request->service_cost;
        $data->total_budget = $request->total_budget;
        $data->perday = $request->perday;
        $data->key_word = $request->key_word;
        $data->geo = $request->geo;
        $data->order_creator_id =  $request->order_creator_id;
        $data->order_status = 1;
        $data->assigned_quantity = 0;
        $data->available_quantity = $request->total_quantity;
        $data->comment = $request->comment;
        $data->workCount = 0;
        $data->total_pay = 0;
        $data->profit = 0;
        $data->total_due = $request->total_budget;

        $data->target_date = date('Y-m-d', strtotime($request->target_date));

        if ($request->file('file')) {
            $file = $request->file('file');
            $filename = date('YmdHi') . $file->getClientOriginalName();
            $file->move(public_path('upload/orderFile'), $filename);
            $data['file'] = $filename;
        }

        $data->status = 1;
        $data->created_by = Auth::user()->id;
        $data->created_date = Carbon::now();
        $data->save();

        if ($data->id != null) {
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->order_id = $data->id;
            $fData->comment = "Order Inserted";
            $fData->status = 1;
            $fData->save();

            $notification = array(
                'message' => 'Order Placed Successfully',
                'alert-type' => 'success'
            );
        } else {
            $notification = array(
                'message' => 'Order Not Placed !!!',
                'alert-type' => 'error'
            );
        }

        return redirect()->route('view-pending-order')->with($notification);
    }


    public function accept(Order $order)
    {
        try {
            $order->update([
                'order_status' => 2,
                'notify' => null,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->order_id = $order->id;
            $fData->comment = "Accept Order";
            $fData->status = 8;
            $fData->save();

            $findUserMail = User::where('id', $order->order_creator_id)->first();

            // if ($order) {
            //     Mail::to($findUserMail->email)->send(new OrderMail($findUserMail, $order));
            //     Mail::to("support@proreviewapp.com")->send(new OrderMail($findUserMail, $order));
            // }

            $notification = array(
                'message' => 'Accept Order Successfully',
                'alert-type' => 'success'
            );

            return Redirect()->back()->with($notification);
        } catch (Exception $e) {
            Log::error($e->getMessage());

            $notification = array(
                'message' => 'OPPS! Something Went Wrong',
                'alert-type' => 'error'
            );

            return back()->with($notification);
        }
    }

    public function viewOrders()
    {
        $datas = Order::whereIn('status', [1, 2, 3])->whereIn('order_status', [2, 3, 4, 5, 6, 7, 9])->orderBy('id', 'desc')->get();
        $workers = User::whereIn('status', [1, 2, 3])->whereIn('role', [1, 2, 4, 6])->get();
        $assign = User::whereIn('status', [1, 2, 3])->whereIn('role', [5, 6])->orderby('role', 'desc')->get();

        $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');

        $authUser = Auth::user();

        return view('admin.page.manageOrder.viewOrders', get_defined_vars());
    }


    public function findOrderDetails(Request $request)
    {
        $data = Order::where('id', $request->id)->first();
        echo json_encode($data);
    }


    public function assignOrder(Request $request)
    {
        $order = Order::find($request->order_id);
        $assigned_qty = $order->assigned_quantity + $request->total_quantity;
        $available_qty = $order->available_quantity - $request->total_quantity;

        $find_id = AssignTable::orderBy('id', 'desc')->first();

        if ($find_id != null) {
            $find_value = $find_id->id;
            $uniqueId = 60000 + $find_value + 1;
        } else {
            $uniqueId = 60000;
        }

        $assign = new AssignTable();
        $assign->ven_Emp_id = $request->ven_Emp_id;
        $assign->unique_id = $uniqueId;
        $assign->order_id = $request->order_id;
        $assign->total_quantity = $request->total_quantity;
        $assign->vendor_rate = $request->service_cost;
        $assign->total_service_cost = $request->total_budget;
        $assign->target_date = $request->target_date;
        $assign->service_type_id = $order->service_type_id;
        $assign->start_point = $request->start_point;
        $assign->total_earn = 0;
        $assign->total_pay = 0;
        $assign->total_due = 0;
        $assign->work_status = 1;

        $assign->status = 1;
        $assign->created_by = Auth::user()->id;
        $assign->created_date = Carbon::now();
        $assign->save();


        if ($assign->id != null) {
            Order::where('id', $request->order_id)->update([
                'assigned_quantity' => $assigned_qty,
                'available_quantity' => $available_qty,
                'order_status' => 9,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->assign_id = $assign->id;
            $fData->comment = "Order Assigned";
            $fData->status = 1;
            $fData->save();


            $notification = array(
                'message' => 'Order Assigned Successfully ',
                'alert-type' => 'success'
            );
        } else {
            $notification = array(
                'message' => 'Order Not Assigned!!!',
                'alert-type' => 'error'
            );
        }

        return redirect()->route('view-orders')->with($notification);
    }

    public function decline($id)
    {
        Order::where('id', $id)->update([
            'order_status' => 8,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->order_id = $id;
        $fData->comment = "Dicline Order";
        $fData->status = 9;
        $fData->save();

        $findOrder = Order::where('id', $id)->first();
        $findUserMail = User::where('id', $findOrder->order_creator_id)->first();

        if (Order::find($id)) {
            Mail::to($findUserMail->email)->send(new OrderMail($findUserMail, $findOrder));
            Mail::to("support@proreviewapp.com")->send(new OrderMail($findUserMail, $findOrder));
        }

        $notification = array(
            'message' => 'Dicline Order Successfully',
            'alert-type' => 'success'
        );

        return Redirect()->back()->with($notification);
    }

    public function ViewAssignOrder()
    {
        $datas = AssignTable::whereIn('status', [1, 2, 3])->whereIn('work_status', [1, 2, 3, 4, 5, 6, 7, 8, 9])->orderBy('id', 'desc')->get();
        $workers = User::whereIn('status', [1, 2, 3])->whereIn('role', [4, 6])->get();
        $employees = User::whereIn('status', [1, 2, 3])->whereIn('role', [2, 5])->get();
        $authUser = Auth::user();

        return view('admin.page.manageOrder.viewAssignTable', get_defined_vars());
    }

    public function ViewComAssignOrder()
    {
        $datas = AssignTable::whereIn('status', [1, 2, 3])->where('work_status', 10)->orderBy('id', 'desc')->get();
        $workers = User::whereIn('status', [1, 2, 3])->whereIn('role', [4, 6])->get();
        $authUser = Auth::user();

        return view('admin.page.manageOrder.completeAssignOrder', get_defined_vars());
    }

    public function ViewCompletedOrder()
    {
        $finished = Order::whereIn('status', [1, 2, 3])->where('order_status', 10)->orderBy('id', 'desc')->get();
        $service = ServiceType::whereIn('status', [1, 2, 3])->get();

        return view('admin.page.manageOrder.completedOrder', get_defined_vars());
    }


    public function editAssignOrders(Request $request)
    {
        $datas = DB::table('assign_tables')
            ->join('orders', 'assign_tables.order_id', '=', 'orders.id')
            ->select('assign_tables.*', 'orders.available_quantity as available', 'orders.service_cost as serviceCost', 'orders.target_date as tDate')
            ->where('assign_tables.id', $request->id)
            ->first();
        echo json_encode($datas);
    }
    public function edit(Request $request)
    {
        $assign = AssignTable::find($request->assign_id);

        if ($request->total_quantity > $assign->total_quantity) {
            $qty = $request->total_quantity - $assign->total_quantity;

            $updateOrder = Order::find($request->order_id);
            $updateOrder->assigned_quantity = $updateOrder->assigned_quantity + $qty;
            $updateOrder->available_quantity = $updateOrder->available_quantity - $qty;
            $updateOrder->save();

            $updateAssign = AssignTable::find($request->assign_id);
            $updateAssign->total_quantity = $request->total_quantity;
            $updateAssign->vendor_rate = $request->service_cost;
            $updateAssign->target_date = $request->target_date;
            $updateAssign->total_service_cost = $request->total_budget;
            $updateAssign->start_point = $request->start_point;
            $updateAssign->save();
        } else {
            $qty = $assign->total_quantity - $request->total_quantity;

            $updateOrder = Order::find($request->order_id);
            $updateOrder->assigned_quantity = $updateOrder->assigned_quantity - $qty;
            $updateOrder->available_quantity = $updateOrder->available_quantity + $qty;
            $updateOrder->save();

            $updateAssign = AssignTable::find($request->assign_id);
            $updateAssign->total_quantity = $request->total_quantity;
            $updateAssign->vendor_rate = $request->service_cost;
            $updateAssign->target_date = $request->target_date;
            $updateAssign->total_service_cost = $request->total_budget;
            $updateAssign->start_point = $request->start_point;
            $updateAssign->save();
        }

        $notification = array(
            'message' => 'Assign Order Edit Successfully',
            'alert-type' => 'success'
        );

        return Redirect()->back()->with($notification);
    }

    public function hold($id)
    {
        AssignTable::where('id', $id)->update([
            'work_status' => 7,
            'v_work_status' => 7,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->assign_id = $id;
        $fData->comment = "Hold Assign Order";
        $fData->status = 10;
        $fData->save();

        $findAssign = AssignTable::where('id', $id)->first();
        $findOrder = Order::where('id', $findAssign->order_id)->first();
        $findUserMail = User::where('id', $findOrder->order_creator_id)->first();

        if (AssignTable::find($id)) {
            Mail::to($findUserMail->email)->send(new OrderMail($findUserMail, $findOrder));
            Mail::to("support@proreviewapp.com")->send(new OrderMail($findUserMail, $findOrder));
        }

        $notification = array(
            'message' => 'Hold Assign Order Successfully',
            'alert-type' => 'success'
        );

        return Redirect()->back()->with($notification);
    }
    public function resume($id)
    {
        AssignTable::where('id', $id)->update([
            'work_status' => 1,
            'v_work_status' => 1,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->assign_id = $id;
        $fData->comment = "Resume Assign Order";
        $fData->status = 11;
        $fData->save();

        $notification = array(
            'message' => 'Resume Assign Order Successfully',
            'alert-type' => 'success'
        );

        return Redirect()->back()->with($notification);
    }

    public function CheckWorkDetails($id)
    {
        $datas = WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $id)->orderBy('id', 'desc')->get();
        $total =  count(WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $id)->whereIn('work_details_status', [2, 1])->orderBy('id', 'desc')->get());
        $assign = AssignTable::find($id);
        $total_avail = count(WorksDetails::whereIn('status', [1, 2, 3])->where('assign_id', $id)->whereIn('work_details_status', [2, 1, 3, 4, 5])->orderBy('id', 'desc')->get());

        $authUser = Auth::user();

        if ($assign != null) {
            $Orders = Order::find($assign->order_id);

            return view('admin.page.manageOrder.checkWorksDetails.checkWorks', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function updateWorkDetailsId(Request $request)
    {
        $getData = WorksDetails::where('id', $request->id)->first();

        WorksDetails::where('id', $request->id)->update([
            'work_details_status' => $request->p_status,
        ]);

        if ($request->p_status) {
            $countWorks = WorksDetails::where('order_id', $getData->order_id)
                ->where('work_details_status', 2)
                ->count();

            Order::where('id', $getData->order_id)->update(['workCount' => $countWorks]);

            $countByAssign = WorksDetails::where('order_id', $getData->order_id)
                ->where('work_details_status', 2)
                ->where('assign_id', $getData->assign_id)
                ->count();

            $adata = AssignTable::find($getData->assign_id);
            $adata->total_earn = $adata->vendor_rate * $countByAssign;
            $adata->complete_work = $countWorks;
            $adata->save();
        }

        $total =  count(WorksDetails::whereIn('status', [1, 2, 3])->where('order_id', $getData->order_id)->where('work_details_status', 2)->orderBy('id', 'desc')->get());

        $checkData = Order::find($getData->order_id);

        if ($total == $checkData->total_quantity) {
            if ($checkData->order_status == 5) {
                $checkData->order_status = 6;
            } else {
                $checkData->order_status = 4;
            }

            $checkData->reason = null;
            $checkData->save();
        }

        // New Update
        $findWork = WorksDetails::where('id', $request->id)->first();

        $getWorks = WorksDetails::where('vandor_id', $findWork->vandor_id)->where('assign_id', $findWork->assign_id)->get();

        $allMatch = true;
        foreach ($getWorks as $item) {
            if ($item->work_details_status != 2 || $item->posting_status != 1) {
                $allMatch = false;
                break;
            }
        }

        $findAssignOrder = AssignTable::where('id', $findWork->assign_id)->first();

        if ($allMatch) {
            $findAssignOrder->update([
                'work_status'    => 4,
                'v_work_status'  => 4,
                'posting_status' => 1,
            ]);
        } else {
            $findAssignOrder->update([
                'work_status'    => 3,
                'v_work_status'  => 3,
            ]);
        }

        echo json_encode($getData);
    }

    public function updateAssignWorStatus(Request $request)
    {
        AssignTable::where('id', $request->id)->update([
            'work_status' => $request->value,
            'v_work_status' => $request->value,
        ]);
        $getData = AssignTable::where('id', $request->id)->first();

        echo json_encode($getData);
    }

    public function CheckWork($id)
    {
        $Orders = Order::find($id);

        if ($Orders != null) {
            $datas = WorksDetails::whereIn('status', [1, 2, 3])->where('order_id', $id)->orderBy('id', 'desc')->get();
            $total =  count(WorksDetails::whereIn('status', [1, 2, 3])->where('order_id', $id)->whereIn('work_details_status', [1, 2])->orderBy('id', 'desc')->get());

            return view('admin.page.manageOrder.checkWorksDetails.checkWorkOnOrder', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function updateOrderStatus(Request $request)
    {
        if ($request->value == 7) {
            $total = DB::select('SELECT COUNT(id)as total, assign_id FROM works_details WHERE order_id =? AND work_details_status BETWEEN 1 and 2 GROUP BY assign_id', [$request->id]);

            foreach ($total as $total_data) {
                AssignTable::where('id', $total_data->assign_id)->update([
                    'work_status' => $request->value,
                    'v_work_status' => $request->value,
                    'complete_work' => $total_data->total,
                ]);
            }
            $total_o_w = WorksDetails::where('order_id', $request->id)->whereIn('work_details_status', [1, 2])->count('id');

            $order = Order::find($request->id);
            $current_due = ($total_o_w * $order->service_cost - $order->total_pay);

            Order::where('id', $request->id)->update([
                'order_status' => $request->value,
                'total_due' => $current_due,
            ]);
        } else {
            AssignTable::where('order_id', $request->id)->update([
                'work_status' => $request->value,
                'v_work_status' => $request->value,
            ]);
            Order::where('id', $request->id)->update([
                'order_status' => $request->value,
            ]);
        }
        $getData = Order::where('id', $request->id)->first();

        echo json_encode($getData);
    }
    public function updateWorkDetailsDate(Request $request)
    {
        WorksDetails::where('id', $request->id)->update([
            'created_date' => $request->p_status,
        ]);

        $getData = WorksDetails::where('id', $request->id)->first();

        echo json_encode($getData);
    }

    public function assignToCheckWork(Request $request)
    {
        $assign = new WorkCheck();
        $assign->emp_id = $request->ven_Emp_id;
        $assign->assign_id = $request->assign_id;
        $assign->work_type = 1;

        $assign->status = 1;
        $assign->created_by = Auth::user()->id;
        $assign->created_date = Carbon::now();
        $assign->save();

        $notification = array(
            'message' => 'Order Assigned Successfully ',
            'alert-type' => 'success'
        );

        return redirect()->route('view-assign-orders')->with($notification);
    }

    public function findUserTypeToAssign(Request $request)
    {
        $datas = User::find($request->id);
        echo json_encode($datas);
    }


    public function  findWorkCheck(Request $request)
    {
        $datas = count(WorkCheck::where('assign_id', $request->id)->get());
        echo json_encode($datas);
    }

    // Update User Name
    public function  updateUserName(Request $request)
    {
        WorksDetails::where('id', $request->id)->update([
            'user_name' => $request->value,
        ]);

        $getData = WorksDetails::where('id', $request->id)->first();

        echo json_encode($getData);
    }

    public function holdOrder()
    {
        $datas = Order::whereIn('status', [1, 2, 3])->where('order_status', 7)->orderBy('id', 'desc')->get();
        $workers = User::whereIn('status', [1, 2, 3])->whereIn('role', [4, 6])->get();

        $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
        if ($datas != null) {
            return view('admin.page.manageOrder.viewHoldOrder', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }
    public function holdAssignOrder()
    {
        $datas = AssignTable::whereIn('status', [1, 2, 3])->where('work_status', 7)->orderBy('id', 'desc')->get();
        $workers = User::whereIn('status', [1, 2, 3])->whereIn('role', [4, 6])->get();
        $employees = User::whereIn('status', [1, 2, 3])->whereIn('role', [2, 5])->get();
        if ($datas != null) {
            return view('admin.page.manageOrder.viewHoldAssignOrder', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function canceleOrder()
    {
        $datas = Order::whereIn('status', [1, 2, 3])->orderBy('id', 'desc')->where('order_status', 11)->get();
        if ($datas != null) {
            return view('admin.page.manageOrder.viewCanceleOrder', get_defined_vars());
        } else {
            return view('admin.404');
        }
    }

    public function canceledAssignedOrder()
    {
        $datas = AssignTable::whereIn('status', [1, 2, 3])->where('work_status', 11)->orderBy('id', 'desc')->get();

        return view('admin.page.manageOrder.canceledAssignOrder', get_defined_vars());
    }
}
