<?php

namespace App\Http\Controllers\accounts\vendor;

use App\Models\Order;
use App\Models\Accounts;
use App\Models\RiskFund;
use App\Models\FootPrint;
use App\Models\AssignTable;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\VendorAccount;
use App\Models\VendorPayment;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class PaymentReceivedController extends Controller
{
    public function findAssignOrder(Request $request)
    {
        $findAssignOrder = AssignTable::where('assign_tables.ven_Emp_id', $request->findID)
                            ->join('orders','assign_tables.order_id','=','orders.id')
                            ->whereIn('orders.order_status', [2,3,4,5,6,7,8,9,10,11])
                            ->whereIn('assign_tables.work_status', [3,4,5,6,7,10,11])
                            ->whereIn('assign_tables.status', [1,2,3])
                            ->where('assign_tables.total_earn', '>', 0)
                            ->where('assign_tables.total_due', '>', 0)
                            ->pluck("assign_tables.unique_id","assign_tables.id","orders.order_status");

        echo json_encode($findAssignOrder);
    }

    public function findAssignDetails(Request $request)
    {
        $findVendorSalary = AssignTable::where('id', $request->assignID)->first();

        echo json_encode($findVendorSalary);
    }

    public function findOrderDetails(Request $request)
    {
        $findVendorSalary = AssignTable::where('id', $request->assignID)->first();
        $findOrderDetails = Order::where('id', $findVendorSalary->order_id)->first();

        echo json_encode($findOrderDetails);
    }

    public function getPaymentFormDetails(Request $request)
    {
        if ($request->payFormValue == 1) {
            $findAccDetails = Accounts::where('id', 1)->first();
        } else if ($request->payFormValue == 2) {
            $findAccDetails = RiskFund::where('id', 1)->first();
        } else {
            $get_data = VendorAccount::where('balance_holder', $request->vendor_id)->first();
            $findAccDetails = $get_data ? $get_data : 0;
        }

        echo json_encode($findAccDetails);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'vendor_id' => 'required',
            'assign_id' => 'required',
            'order_id' => 'required',
            'payment_method_id' => 'required',
            'vendorPay' => 'required',
            'payment_from' => 'required',
            'trans_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            
            return back()->with($notification);
        } else {
            $findOrder = Order::where('id', $request->order_id)->first();

            $data = new VendorPayment();
            $data->transactionID = $request->transactionID;
            $data->vendor_id = $request->vendor_id;
            $data->assign_id = $request->assign_id;
            $data->order_id = $request->order_id;
            $data->payment_from = $request->payment_from;
            $data->payment_method_id= $request->payment_method_id;

            $data->amount = $request->vendorSalary;
            $data->pay = $request->vendorPay;

            if ($findOrder->order_status == 7) {
                $data->due = $request->vendorSalary - $request->vendorPay;
            } else {
                $data->due = $request->totalDue;
            }

            $data->trans_date= $request->trans_date;
            $data->note = $request->note;
            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();

            $findAssignData = AssignTable::where('id', $request->assign_id)->first();
            $totalPay = $findAssignData->total_pay + $request->vendorPay;

            if ($findOrder->order_status == 7) {
                $totalDue = $request->vendorSalary - $request->vendorPay;
            } else {
                $totalDue = $request->totalDue;
                // $totalDue = $findAssignData->total_due - $request->vendorPay;
            }

            AssignTable::find($request->assign_id)->update([
                'total_pay'=> $totalPay,
                'total_due'=> $totalDue,
            ]);

            $saveTrans = new Transaction();
            $saveTrans->vendor_id = $request->vendor_id;
            $saveTrans->vendor_payments_id = $data->id;
            $saveTrans->trans_type = 2;
            $saveTrans->amount = $request->vendorPay;
            $saveTrans->date= $request->trans_date;
            $saveTrans->note = $request->note;
            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();

            if ($request->payment_from == 2) {
                $RiskFundTotal = RiskFund::first();
                $RiskFundDebit = $RiskFundTotal->debit + $request->vendorPay;
                $RiskFundAmount = $RiskFundTotal->total - $request->vendorPay;
                
                RiskFund::find(1)->update([
                    'debit'=> $RiskFundDebit,
                    'total'=> $RiskFundAmount,
                ]);
            } else {
                $accountsTotal = Accounts::first();
                $totalDebit = $accountsTotal->debit + $request->vendorPay;
                $totalAmount = $accountsTotal->total - $request->vendorPay;
                
                Accounts::find(1)->update([
                    'debit'=> $totalDebit,
                    'total'=> $totalAmount,
                ]);

                if ($request->payment_from == 3) {
                    $get_data = VendorAccount::where('balance_holder', $request->vendor_id)->first();

                    $debit = $get_data->debit + $request->vendorPay;
                    $amount = $get_data->current_balance - $request->vendorPay;

                    $get_data->debit = $debit;
                    $get_data->current_balance = $amount;
                    $get_data->save();
                } else {
                    $get_data = VendorAccount::where('balance_holder', $request->vendor_id)->first();
                    $amount = $get_data->current_balance + $request->vendorPay;
                    
                    $get_data->current_balance = $amount;
                    $get_data->save();
                }
            }

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "VendorPayment";
            $fData->table_id = $data->id;
            $fData->comment = "Vendor Payment Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Vendor Payment Successfully Completed.',
                'alert-type'=>'success'
            );

            return back()->with($notification);
        }
    }
}