<?php

namespace App\Http\Controllers\accounts\client;

use App\Models\User;
use App\Models\Order;
use App\Models\FootPrint;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\BudgetReceived;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class PayController extends Controller
{
    public function index()
    {
        $auth_user = Auth::user();
        $getBudgetReceived = BudgetReceived::whereIn('status', [1,2,3,4])->where('client_id', $auth_user->id)->get();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();
        // dd($getBudgetReceived);
        
        return view('admin.page.accounts.client.payment_to_admin', get_defined_vars());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'client_id' => 'required',
            'payment_method_id' => 'required',
            'received_amount' => 'required',
            'trans_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new BudgetReceived();
            $data->transactionID = $request->transactionID;
            $data->client_id = $request->client_id;
            $data->payment_method_id = $request->payment_method_id;
            $data->received_amount = $request->received_amount;
            $data->trans_date= $request->trans_date;
            $data->note = $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 3;
            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "BudgetReceived";
            $fData->table_id = $data->id;
            $fData->comment = "Payment Received";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Payment Received Successfully Done.',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }
}
