<?php

namespace App\Http\Controllers\accounts\administration\withdraw;

use App\Models\Accounts;
use App\Models\Withdraw;
use App\Models\FootPrint;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class WithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $accountsTotal = Accounts::where('id', 1)->first();
        // dd($accountsTotal);
        $getWithdraw = Withdraw::whereIn('status', [1,2])->get();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();
        return view('admin.page.accounts.administration.withdraw.withdraw', get_defined_vars());
    }


    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'to_account' => 'required',
            'payment_method_id' => 'required',
            'withdraw_amount' => 'required',
            'exchange_rate' => 'required',
            'bdt_amount' => 'required',
            'trans_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new Withdraw();
            $data->transactionID = $request->transactionID;
            $data->account_id = $request->account_id;
            $data->payment_method_id = $request->payment_method_id;
            $data->from_account = $request->to_account;
            $data->withdraw_amount = $request->withdraw_amount;
            $data->exchange_rate= $request->exchange_rate;
            $data->bdt_amount= $request->bdt_amount;
            $data->trans_date= $request->trans_date;
            $data->note = $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();
            // dd($data);

            $saveTrans = new Transaction();
            $saveTrans->withdraw_id = $data->id;
            $saveTrans->trans_type = 10;
            $saveTrans->amount = $request->withdraw_amount;
            $saveTrans->date= $request->trans_date;
            $saveTrans->note = $request->note;
            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();
            // dd($saveTrans);

            $accountsTotal = Accounts::first();
            $totalWithdraw = $accountsTotal->withdraw + $request->withdraw_amount;
            $totalAmount = $accountsTotal->total - $request->withdraw_amount;

            // dd($totalWithdraw);

            Accounts::find(1)->update([
                'withdraw'=> $totalWithdraw,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "Withdraw";
            $fData->table_id = $data->id;
            $fData->comment = "Withdraw Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Withdraw Successfully Done.',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function findWithdrawID(Request $request)
    {
        // http://127.0.0.1:8000/findWithdrawID?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&WithdrawID=1
        // $findWithdrawID = Withdraw::where('id', $request->WithdrawID)->first();
        $findWithdraw = Withdraw::where('id', $request->WithdrawID)->first();
        if($findWithdraw->payment_method_id != null)
        {
            $findWithdrawID = DB::table('withdraws')
                        ->select('payment_methods.name as payMethodName','withdraws.*')
                        ->join('payment_methods','withdraws.payment_method_id','=','payment_methods.id')
                        ->where('withdraws.id', $request->WithdrawID)
                        ->first();
        }else{
            $findWithdrawID = Withdraw::where('id', $request->WithdrawID)->firstOrFail();
        }

        echo json_encode($findWithdrawID);
    }

    public function update(Request $request)
    {
        // dd($request->all());
        $findData = Withdraw::where('id', $request->id)->first();

        if(is_numeric($request->payment_method_id)){
            $paymentMethodId = $request->payment_method_id;
            echo "req->id" ;
        }else{
            $paymentMethodId = $findData->payment_method_id;
            echo "db->id" ;
        }
        // dd($paymentMethodId);

        Withdraw::find($request->id)->update([
            'transactionID'=> $request->transactionID,
            'payment_method_id'=> $paymentMethodId,
            'from_account'=> $request->to_account,
            'withdraw_amount'=> $request->withdraw_amount,
            'exchange_rate'=> $request->exchange_rate,
            'bdt_amount'=> $request->bdt_amount,
            'trans_date'=> $request->trans_date,
            'note'=> $request->note,

            'status'=> 2,
            'updated_by'=>Auth::user()->id,
            'updated_date'=>Carbon::now()
        ]);

        Transaction::where('withdraw_id', $findData->id)->update([
            'amount'=> $request->withdraw_amount,
            'note'=> $request->note,

            'status'=> 2,
            'updated_by'=>Auth::user()->id,
            'updated_date'=>Carbon::now()
        ]);

        $accountsTotal = Accounts::first();
        $totalWithdraw = ($accountsTotal->withdraw - $findData->withdraw_amount) + $request->withdraw_amount;
        $totalAmount = ($accountsTotal->total + $findData->withdraw_amount) - $request->withdraw_amount;

        Accounts::find(1)->update([
            'withdraw'=> $totalWithdraw,
            'total'=> $totalAmount,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "Withdraw";
        $fData->table_id = $request->id;
        $fData->comment = "Withdraw Updated";
        $fData->status = 2;
        $fData->save();

        $notification= array(
            'message' =>'Withdraw Updated Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function destroy($id)
    {
        $findData = Withdraw::where('id', $id)->first();
        // dd($id);
        Withdraw::find($id)->update([
            'status'=> 0,
            'deleted_by'=>Auth::user()->id,
            'deleted_date'=>Carbon::now()
        ]);

        Transaction::where('withdraw_id', $findData->id)->update([
            'status'=> 0,
            'deleted_by'=>Auth::user()->id,
            'deleted_date'=>Carbon::now()
        ]);

        $accountsTotal = Accounts::first();
        $totalWithdraw = $accountsTotal->withdraw - $findData->withdraw_amount;
        $totalAmount = $accountsTotal->total + $findData->withdraw_amount;

        Accounts::find(1)->update([
            'withdraw'=> $totalWithdraw,
            'total'=> $totalAmount,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "Withdraw";
        $fData->table_id = $id;
        $fData->comment = "Withdraw Deleted";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Withdraw Deleted Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
}
