<?php

namespace App\Http\Controllers\accounts\administration\budgetReceived;

use App\Models\User;
use App\Models\Order;
use App\Models\FootPrint;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\BudgetReceived;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Models\VendorAccount;
use App\Models\VendorBudgetReceived;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class BudgetReceivedController extends Controller
{
    public function index()
    {
        // dd("Hello");
        $getBudgetReceived = BudgetReceived::whereIn('status', [1,2,3,4])->get();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();
        $getClients = User::where('role', 3)->whereIn('status', [1,2,3])->get();
        return view('admin.page.accounts.administration.budgetReceived.budgetReceived', get_defined_vars());
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'client_id' => 'required',
            'payment_method_id' => 'required',
            'received_amount' => 'required',
            'trans_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new BudgetReceived();
            $data->transactionID = $request->transactionID;
            $data->client_id = $request->client_id;
            $data->payment_method_id = $request->payment_method_id;
            $data->received_amount = $request->received_amount;
            // $data->charge= $request->charge;
            // $data->total_amount= $request->total_amount;
            // $data->charge_note= $request->charge_note;
            $data->trans_date= $request->trans_date;
            $data->note = $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();
            // dd($data);

            $saveTrans = new Transaction();
            $saveTrans->budget_received_id = $data->id;
            $saveTrans->trans_type = 1;
            $saveTrans->amount = $request->received_amount;
            $saveTrans->date= $request->trans_date;
            $saveTrans->note = $request->note;
            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();
            // dd($saveTrans);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "BudgetReceived";
            $fData->table_id = $data->id;
            $fData->comment = "Budget Received Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Budget Received Successfully Done.',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function findBudgtRecID(Request $request)
    {
        // http://127.0.0.1:8000/findBudgtRecID?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&budgetRId=1
        // $findBudgtRecID = BudgetReceived::where('id', $request->budgetRId)->first();

        $findWithdraw = BudgetReceived::where('id', $request->budgetRId)->first();
        if($findWithdraw->payment_method_id != null || $findWithdraw->client_id != null)
        {
            $findBudgtRecID = DB::table('budget_receiveds')
                        ->select('users.id as clientID', 'users.name as clientName', 'payment_methods.name as payMethodName','budget_receiveds.*')
                        ->join('users','budget_receiveds.client_id','=','users.id')
                        ->join('payment_methods','budget_receiveds.payment_method_id','=','payment_methods.id')
                        ->where('budget_receiveds.id', $request->budgetRId)
                        ->first();
        }else{
            $findBudgtRecID = BudgetReceived::where('id', $request->budgetRId)->first();
        }

        echo json_encode($findBudgtRecID);
    }

    public function update(Request $request)
    {
        // dd($request->all());
        $findData = BudgetReceived::where('id', $request->id)->first();

        if($findData != null){

            if(is_numeric($request->payment_method_id)){
                $paymentMethodId = $request->payment_method_id;
                // echo "req->id" ;
            }else{
                $paymentMethodId = $findData->payment_method_id;
                // echo "db->id" ;
            }
            if(is_numeric($request->client_id)){
                $clientID = $request->client_id;
                // echo "req->id" ;
            }else{
                $clientID = $findData->client_id;
                // echo "db->id" ;
            }
            // dd($paymentMethodId);

            BudgetReceived::find($request->id)->update([
                'transactionID'=> $request->transactionID,
                'client_id'=> $clientID,
                'payment_method_id'=> $paymentMethodId,
                'received_amount'=> $request->received_amount,
                // 'charge'=> $request->charge,
                // 'total_amount'=> $request->total_amount,
                // 'charge_note'=> $request->charge_note,
                'trans_date'=> $request->trans_date,
                'note'=> $request->note,

                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            Transaction::where('budget_received_id', $findData->id)->update([
                'amount'=> $request->received_amount,
                'note'=> $request->note,

                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "BudgetReceived";
            $fData->table_id = $request->id;
            $fData->comment = "Budget Received Updated";
            $fData->status = 2;
            $fData->save();

            $notification= array(
                'message' =>'Budget Received Updated Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }

    public function destroy($id)
    {
        $findData = BudgetReceived::where('id', $id)->first();
        // dd($id);
        BudgetReceived::find($id)->update([
            'status'=> 0,
            'deleted_by'=>Auth::user()->id,
            'deleted_date'=>Carbon::now()
        ]);

        Transaction::where('budget_received_id', $findData->id)->update([
            'status'=> 0,
            'deleted_by'=>Auth::user()->id,
            'deleted_date'=>Carbon::now()
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "BudgetReceived";
        $fData->table_id = $id;
        $fData->comment = "Budget Received Deleted";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Budget Received Deleted Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function vendorBudgetReceive()
    {
        $getBudgetReceived = VendorBudgetReceived::whereIn('status', [1,2])->get();
        $pendingBudgetReceived = VendorBudgetReceived::where('status', 3)->get();
        $canceleBudgetReceived = VendorBudgetReceived::where('status', 4)->get();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();
    
        return view('admin.page.accounts.administration.budgetReceived.vendor.budgetReceivedTab', get_defined_vars());
    }

    public function vendorBudgetReceiveAccept($id)
    {
        $data = VendorBudgetReceived::find($id);
        $data ->status         = 2;
        $data ->updated_by     = Auth::user()->id;
        $data ->updated_date   = Carbon::now();
        $data->save();


        $saveTrans = new Transaction();
        $saveTrans->budget_received_id = $data->id;
        $saveTrans->trans_type = 1;
        $saveTrans->amount = $data->received_amount;
        $saveTrans->date= $data->trans_date;
        $saveTrans->note = $data->note;
        $saveTrans->created_by = $data->created_by;
        $saveTrans->created_date = Carbon::now();
        $saveTrans->status = 1;
        $saveTrans->save();
        // dd($saveTrans);

        $vendorAccount = VendorAccount::where('balance_holder', $data->received_by)->first();
        if($vendorAccount)
        {
            $vendorAccount->current_balance += $data->received_amount;
            $vendorAccount->save();
        }else{
            VendorAccount::create([
                'balance_holder' => $data->received_by,
                'current_balance' => $data->received_amount,
            ]);
        }

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "VendorBudgetReceived";
        $fData->table_id = $data->id;
        $fData->comment = "Budget Received Active";
        $fData->status = 3;
        $fData->save();

        $notification= array(
            'message' =>'Budget Received Accept Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function vendorBudgetReceiveDeclined($id)
    {
        $data = VendorBudgetReceived::find($id);
        $data ->status         = 4;
        $data ->updated_by     = Auth::user()->id;
        $data ->updated_date   = Carbon::now();
        $data->save();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "VendorBudgetReceived";
        $fData->table_id = $data->id;
        $fData->comment = "Budget Received Declined";
        $fData->status = 4;
        $fData->save();

        $notification= array(
            'message' =>'Budget Received Decline Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function clientBudgetReceiveAccept($id)
    {
        $data = BudgetReceived::find($id);
        $data ->status         = 2;
        $data ->updated_by     = Auth::user()->id;
        $data ->updated_date   = Carbon::now();
        $data->save();
        $saveTrans = new Transaction();
        $saveTrans->budget_received_id = $data->id;
        $saveTrans->trans_type = 1;
        $saveTrans->amount = $data->received_amount;
        $saveTrans->date= $data->trans_date;
        $saveTrans->note = $data->note;
        $saveTrans->created_by = $data->created_by;
        $saveTrans->created_date = Carbon::now();
        $saveTrans->status = 1;
        $saveTrans->save();
        // dd($saveTrans);
        // $vendorAccount = VendorAccount::where('balance_holder', $data->received_by)->first();
        // if($vendorAccount)
        // {
        //     $vendorAccount->current_balance += $data->received_amount;
        //     $vendorAccount->save();
        // }else{
        //     VendorAccount::create([
        //         'balance_holder' => $data->received_by,
        //         'current_balance' => $data->received_amount,
        //     ]);
        // }
        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "VendorBudgetReceived";
        $fData->table_id = $data->id;
        $fData->comment = "Budget Received Active";
        $fData->status = 3;
        $fData->save();
        $notification= array(
            'message' =>'Budget Received Accept Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function clientBudgetReceiveDeclined($id)
    {
        $data = BudgetReceived::find($id);
        $data ->status         = 4;
        $data ->updated_by     = Auth::user()->id;
        $data ->updated_date   = Carbon::now();
        $data->save();
        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "VendorBudgetReceived";
        $fData->table_id = $data->id;
        $fData->comment = "Budget Received Declined";
        $fData->status = 4;
        $fData->save();
        $notification= array(
            'message' =>'Budget Received Decline Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
}
