<?php

namespace App\Http\Controllers\accounts\administration;

use App\Models\Accounts;
use App\Models\FootPrint;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\SubscriptionPayment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class SubscriptionPaymentController extends Controller
{
    public function store(Request $request)
    {
        // dd($request->all());

        $start_date = $request->billing_month;
        $date = strtotime($start_date);
        $dataDetails = date('Y-m-d', $date);
        // dd($dataDetails);

        $validator = Validator::make($request->all(), [
            'receiver_name' => 'required',
            'payment_method_id' => 'required',
            'amount' => 'required',
            'trans_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new SubscriptionPayment();
            $data->transactionID = $request->transactionID; 
            $data->subscription_id = $request->subscription_id; 
            $data->subscription_type_id = $request->subscription_type_id;
            $data->receiver_name = $request->receiver_name;
            $data->payment_method_id = $request->payment_method_id;
            $data->amount= $request->amount;
            $data->trans_number= $request->transactionID;
            $data->billing_month= $dataDetails;
            $data->trans_date= $request->trans_date;
            $data->note = $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();
            // dd($data);

            $saveTrans = new Transaction();
            $saveTrans->subscriptionID = $request->subscription_id;
            $saveTrans->subsPaymentId = $data->id;
            $saveTrans->trans_type = 11;
            $saveTrans->amount = $request->amount;
            $saveTrans->date= $request->trans_date;
            $saveTrans->note = $request->note;
            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();

            $accountsTotal = Accounts::first();
            $totalDebit = $accountsTotal->debit + $request->amount;
            $totalAmount = $accountsTotal->total - $request->amount;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "SubscriptionPayment";
            $fData->table_id = $data->id;
            $fData->comment = "Subscription Payment Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Payment given Successfully',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function findSubscriptionPaymentID(Request $request)
    {
        // http://127.0.0.1:8000/findSubscriptionPaymentID?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&subsPayId=1
        // $findSubscriptionPaymentID = EmployeeSalary::where('id', $request->subsPayId)->first();
        $findSubscriptionPaymentID = DB::table('subscription_payments')
                    ->select('payment_methods.name as payMethod','subscription_payments.*')
                    ->join('payment_methods','subscription_payments.payment_method_id','=','payment_methods.id')
                    ->where('subscription_payments.id', $request->subsPayId)
                    ->first();

        echo json_encode($findSubscriptionPaymentID);
    }

    public function update(Request $request)
    {
        //dd($request->all());

        $findSubs = SubscriptionPayment::where('id', $request->subPayID)->first();

        if($findSubs != null){

            if(is_numeric($request->payment_method_id)){
                $payment_method_id = $request->payment_method_id;
                // echo "req->id" ;
            }else{
                $payment_method_id = $findSubs->payment_method_id;
                // echo "db->id" ;
            }

            SubscriptionPayment::find($request->subPayID)->update([
                'payment_method_id'=> $payment_method_id,
                'receiver_name'=> $request->receiver_name,
                'billing_month'=> $request->billing_month,
                'amount'=> $request->amount,
                'trans_number'=> $request->trans_number,
                'trans_date'=> $request->trans_date,
                'note'=> $request->note,

                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            Transaction::where('subsPaymentId', $findSubs->id)->update([
                'amount'=> $request->amount,
                'note'=> $request->note,

                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            $accountsTotal = Accounts::first();
            $totalDebit = ($accountsTotal->debit - $findSubs->amount) + $request->amount;
            $totalAmount = ($accountsTotal->total + $findSubs->amount) - $request->amount;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "SubscriptionPayment";
            $fData->table_id = $request->subPayID;
            $fData->comment = "Subscription Payment Updated";
            $fData->status = 2;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Payment Updated Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }

    public function destroy($id)
    {
        $findSubs = SubscriptionPayment::where('id', $id)->first();

        if($findSubs != null){
            SubscriptionPayment::find($id)->update([
                'status'=> 0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            Transaction::where('subsPaymentId', $findSubs->id)->update([
                'status'=> 0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            $accountsTotal = Accounts::first();
            $totalDebit = ($accountsTotal->debit - $findSubs->amount);
            $totalAmount = ($accountsTotal->total + $findSubs->amount);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "SubscriptionPayment";
            $fData->table_id = $id;
            $fData->comment = "Subscription Payment Deleted";
            $fData->status = 0;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Payment Deleted Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }
}
